% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.r
\name{scale}
\alias{scale}
\alias{scale.annmatrix}
\title{Scaling and Centering of annmatrix Objects}
\usage{
\method{scale}{annmatrix}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{annmatrix object.}

\item{center}{either a logical value or a numeric vector of length equal to the number of columns of 'x' (default is TRUE).}

\item{scale}{either a logical value or a numeric vector of length equal to the number of columns of 'x' (default is TRUE).}
}
\value{
The centered and/or scaled annmatrix object with additional attributes "scaled:center" and "scaled:scale" holding the numbers used for centering and scaling of each column.
}
\description{
Centers and scales the columns of an annmatrix object.
}
\details{
Behaves exactly as \code{scale} on a regular matrix with the preservation of 'annmatrix' class being the only difference.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

scale(X)
scale(X, center = colMeans(X))

}
\seealso{
\code{scale.default}
}
\author{
Karolis Koncevičius
}
