% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.r
\name{stack}
\alias{stack}
\alias{stack.annmatrix}
\title{Stack an annmatrix object}
\usage{
\method{stack}{annmatrix}(x, ...)
}
\arguments{
\item{x}{annmatrix object.}

\item{...}{further arguments passed to or from methods.}
}
\value{
transposed annmatrix object
}
\description{
Turns annmatrix into a data frame by transforming the matrix along with row and column annotations into separate data frame columns.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

# stack all information into a long-format data.frame
Y <- stack(X)

}
\author{
Karolis Koncevičius
}
