% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_airlines.R
\name{get_airlines}
\alias{get_airlines}
\title{Query nycflights13-Like Airlines Data}
\source{
\url{https://www.bts.gov/}
}
\usage{
get_airlines(dir = NULL, flights_data = NULL)
}
\arguments{
\item{dir}{An optional character string giving the directory
to save datasets in. By default, datasets will not be saved to file.}

\item{flights_data}{Optional---either a filepath as a 
character string or a dataframe outputted by \code{\link{get_flights}} that
will be used to subset the output to only include relevant carriers/planes.
If not supplied, all carriers/planes will be returned.}
}
\value{
A data frame with <2k rows and 2 variables:
\describe{
\item{carrier}{Two or three length letter or number abbreviation. In cases whgere the the Unique Carrier Code has been use more than once, a suffix is added.
               ex. ML, ML (1). This list matches the `Reporting_Airline` field in the BTS documentation for the flights data set}
\item{name}{Full name}
}
}
\description{
This function generates a dataframe similar to the 
\code{\link[nycflights13]{airlines}} dataset from \code{nycflights13} 
for any US airports and time frame. Please 
note that, even with a strong internet connection, this function 
may take several minutes to download relevant data.
}
\examples{

# run with defaults
\donttest{\dontrun{get_airlines()}}

# if you'd like to only return the airline 
# abbreviations only for airlines that appear in 
# \code{flights}, query your flights dataset first, 
# and then supply it as a flights_data argument
\donttest{\dontrun{get_airlines(flights_data = get_flights("PDX", 2018, 6))}}

}
\seealso{
\code{\link{get_flights}} for flight data,
\code{\link{get_weather}} for weather data, 
\code{\link{get_airports}} for airports data,
\code{\link{get_planes}} for planes data,
or \code{\link{anyflights}} for a wrapper function.

Use the \code{\link{as_flights_package}} function to convert this dataset 
to a data-only package.
}
