% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_stats.R
\name{influence_stats}
\alias{influence_stats}
\title{Influence statistics}
\usage{
influence_stats(
  model,
  n = 6L,
  rtype = c("studentized", "standardized"),
  criterion = c("cooks", "dffits")
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{n}{an integer vector of length up to \code{dim(x)} (or 1,
    for non-dimensioned objects). Values specify the indices to be
    selected in the corresponding dimension (or along the length) of the
    object. A positive value of \code{n[i]} includes the first/last
    \code{n[i]} indices in that dimension, while a negative value
    excludes the last/first \code{abs(n[i])}, including all remaining
    indices. \code{NA} or non-specified values (when \code{length(n) <
      length(dim(x))}) select all indices in that dimension. Must
    contain at least one non-missing value.}

\item{rtype}{The residual type to plot on the y-axis. The
default is \code{"studentized"}. The other option is
\code{"standardized"}.}

\item{criterion}{The criterion that decides the size of
the points. The default is \code{"cooks"}. The other
option is \code{"dffits"}.}
}
\value{
A data frame of influence-related statistics.
}
\description{
\code{influence_stats} returns a data frame with
influence-related statistics ordered from the largest
to smallest magnitude of the \code{criterion}.
}
\examples{
lmod <- lm(murder ~ hs_grad + urban + poverty + single,
           data = crime2009)
influence_stats(lmod, n = 3)
influence_stats(lmod, rtype = "stan", crit = "df")
}
\seealso{
\code{\link[stats]{rstandard}},
  \code{\link[stats]{rstudent}},
  \code{\link[stats]{hatvalues}}
  \code{\link[stats]{cooks.distance}},
  \code{\link[stats]{dffits}}
}
\author{
Joshua French
}
