% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regGeometry.R
\name{regGeometry}
\alias{regGeometry}
\title{Register a new geometry entry}
\usage{
regGeometry(
  ...,
  subset = NULL,
  gSeries = NULL,
  label = NULL,
  ancillary = NULL,
  layer = NULL,
  archive = NULL,
  archiveLink = NULL,
  downloadDate = NULL,
  updateFrequency = NULL,
  notes = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{...}{\code{\link[=character]{character(1)}}\cr optional named argument selecting
the main territory into which this geometry is nested. The name of this
must be a class of the gazetteer and the value must be one of the territory
names of that class, e.g. \emph{nation = "Estonia"}.}

\item{subset}{\code{\link[=character]{character(1)}}\cr optional argument to specify
which subset the file contains. This could be a subset of territorial units
(e.g. only one municipality) or of a target variable.}

\item{gSeries}{\code{\link[=character]{character(1)}}\cr the name of the geometry
dataseries (see \code{\link{regDataseries}}).}

\item{label}{\code{\link[=list]{list(.)}}\cr list of as many columns as there are in
common in the ontology and this geometry. Must be of the form
\code{list(class = columnName)}, with 'class' as the class of the ontology
corresponding to the respective column name in the geometry.}

\item{ancillary}{\code{\link[=list]{list(.)}}\cr optinal list of columns containing
ancillary information. Must be of the form \code{list(attribute =
  columnName)}, where \code{attribute} can be one or
several of \itemize{
\item \code{"name_ltn"} (the english name in latin letters)
\item \code{"name_lcl"} (the name in local language and letters)
\item \code{"code"} (any code describing the unit)
\item \code{"type"} (the type of territorial unit)
\item \code{"uri"} (the semantic web URI) or
\item \code{"flag"} (any flag attributed to the unit).}}

\item{layer}{\code{\link[=character]{character(1)}}\cr the name of the file's layer from
which the geometry should be created (if applicable).}

\item{archive}{\code{\link[=character]{character(1)}}\cr the original file (perhaps a
*.zip) from which the geometry emerges.}

\item{archiveLink}{\code{\link[=character]{character(1)}}\cr download-link of the
archive.}

\item{downloadDate}{\code{\link[=character]{character(1)}}\cr value describing the
download date of this dataset (in YYYY-MM-DD format).}

\item{updateFrequency}{\code{\link[=character]{character(1)}}\cr value describing the
frequency with which the dataset is updated, according to the ISO 19115
Codelist, MD_MaintenanceFrequencyCode. Possible values are: 'continual',
'daily', 'weekly', 'fortnightly', 'quarterly', 'biannually', 'annually',
'asNeeded', 'irregular', 'notPlanned', 'unknown', 'periodic',
'semimonthly', 'biennially'.}

\item{notes}{\code{\link[=character]{character(1)}}\cr optional notes that are assigned
to all features of this geometry.}

\item{overwrite}{\code{\link[=logical]{logical(1)}}\cr whether or not the geometry to
register shall overwrite a potentially already existing older version.}
}
\value{
Returns a tibble of the entry that is appended to
'inv_geometries.csv'.
}
\description{
This function registers a new geometry of territorial units into the
geospatial database.
}
\details{
When processing geometries to which areal data shall be linked,
carry out the following steps: \enumerate{ \item Determine the main
territory (such as a nation, or any other polygon), a \code{subset} (if
applicable), the dataseries of the geometry and the ontology \code{label},
and provide them as arguments to this function. \item Run the function.
\item Export the shapefile with the following properties: \itemize{ \item
Format: GeoPackage \item File name: What is provided as message by this
function \item CRS: EPSG:4326 - WGS 84 \item make sure that 'all fields are
exported'} \item Confirm that you have saved the file.}
}
\examples{
if(dev.interactive()){
  # build the example database
  adb_exampleDB(until = "regDataseries", path = tempdir())

  # The GADM dataset comes as *.7z archive
  regGeometry(gSeries = "gadm",
              label = list(al1 = "NAME_0"),
              layer = "example_geom1",
              archive = "example_geom.7z|example_geom1.gpkg",
              archiveLink = "https://gadm.org/",
              nextUpdate = "2019-10-01",
              updateFrequency = "quarterly")

  # The second administrative level in GADM contains names in the columns
  # NAME_0 and NAME_1
  regGeometry(gSeries = "gadm",
              label = list(al1 = "NAME_0", al2 = "NAME_1"),
              ancillary = list(name_lcl = "VARNAME_1", code = "GID_1", type = "TYPE_1"),
              layer = "example_geom2",
              archive = "example_geom.7z|example_geom2.gpkg",
              archiveLink = "https://gadm.org/",
              nextUpdate = "2019-10-01",
              updateFrequency = "quarterly")
}
}
\seealso{
Other register functions: 
\code{\link{regDataseries}()},
\code{\link{regTable}()}
}
\concept{register functions}
