% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arena.R
\name{create_arena}
\alias{create_arena}
\title{Creates arena object}
\usage{
create_arena(
  live = FALSE,
  N = 500,
  fi_N = NULL,
  fi_B = 10,
  grid_points = 101,
  shap_B = 10,
  funnel_nbins = 5,
  funnel_cutoff = 0.01,
  funnel_factor_threshold = 7,
  fairness_cutoffs = seq(0.05, 0.95, 0.05),
  max_points_number = 150,
  distribution_bins = seq(5, 40, 5),
  enable_attributes = TRUE,
  enable_custom_params = TRUE,
  cl = NULL
)
}
\arguments{
\item{live}{Defines if arena should start live server or generate static json}

\item{N}{number of observations used to calculate dependence profiles}

\item{fi_N}{number of observations used in feature importance}

\item{fi_B}{Number of permutation rounds to perform each variable
in feature importance}

\item{grid_points}{number of points for profile}

\item{shap_B}{Numer of random paths in SHAP}

\item{funnel_nbins}{Number of partitions for numeric columns for funnel plot}

\item{funnel_cutoff}{Threshold for categorical data. Entries less frequent than specified value will be merged into one category in funnel plot.}

\item{funnel_factor_threshold}{Numeric columns with lower number of unique values than value of this parameter will be treated as factors in funnel plot.}

\item{fairness_cutoffs}{vector of available cutoff levels for fairness panel}

\item{max_points_number}{maximum size of sample to plot scatter plots in variable against another panel}

\item{distribution_bins}{vector of available bins count for histogram}

\item{enable_attributes}{Switch for generating attributes of observations and variables. It is required for custom params. Attributes can increase size of static Arena.}

\item{enable_custom_params}{Switch to allowing user to modify observations and generate plots for them.}

\item{cl}{Cluster used to run parallel computations (Do not work in live Arena)}
}
\value{
Empty \code{arena_static} or \code{arena_live} class object.\cr
\code{arena_static}:
\itemize{
  \item{explainer}{ List of used explainers}
  \item{observations_batches}{ List of data frames added as observations}
  \item{params}{ Plots' parameters}
  \item{plots_data}{ List of generated data for plots}
}
\code{arena_live}:
\itemize{
  \item{explainer}{ List of used explainers}
  \item{observations_batches}{ List of data frames added as observations}
  \item{params}{ Plots' parameters}
  \item{timestamp}{ Timestamp of last modification}
}
}
\description{
Creates object with class \code{arena_live} or \code{arena_static} depending on the first argument.
This method is always first in \code{arenar} workflow and you should specify all plots' parameters there.
}
\examples{
library("DALEX")
library("arenar")
library("dplyr", quietly=TRUE, warn.conflicts = FALSE)
# create a model
model <- glm(m2.price ~ ., data=apartments)
# create a DALEX explainer
explainer <- DALEX::explain(model, data=apartments, y=apartments$m2.price)
# prepare observations to be explained
observations <- apartments[1:3, ]
# rownames are used as labels for each observation
rownames(observations) <- paste0(observations$construction.year, "-", observations$surface, "m2")
# generate static arena for one model and 3 observations
arena <- create_arena(live=FALSE) \%>\% push_model(explainer) \%>\% push_observations(observations)
print(arena)
if (interactive()) upload_arena(arena)
}
