% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonPage.R
\name{argonPageTemplate}
\alias{argonPageTemplate}
\title{Create an HTML version of the argonPage}
\usage{
argonPageTemplate(filename = "index", path = getwd(), argonPage, view = TRUE)
}
\arguments{
\item{filename}{HTML filename for instance, index.html.}

\item{path}{Where to store the saved file. By default, getwd().}

\item{argonPage}{Slot for \link{argonPage}.}

\item{view}{Whether to preview the page in a web browser. TRUE by default.}
}
\description{
Create an HTML version of the argonPage
}
\note{
Do not forget to copy the inst folder of the package to the 
root of your website folder.
}
\examples{
if(interactive()){
 library(argonR)
 
 # generate the page
 example <- argonPage(
  title = "ArgonR Static Template",
  author =  "Somebody",
  description = "HTML Static Template",
  navbar = argonNavbar(id = "navbar"),
  footer = argonFooter(),
  # main content
  argonSection(),
  argonSection(),
  argonSection(),
  argonSection(),
  argonSection()
 )
 
 # create the path
 path <- getwd()
 
 # generate the static page
 argonPageTemplate(filename = "example", path = path, argonPage = example)
 
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
