% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streamable_table.R
\name{streamable_table}
\alias{streamable_table}
\title{streamable table}
\usage{
streamable_table(read, write, extension)
}
\arguments{
\item{read}{read function. Arguments should be "\code{file}"
(must be able to take a \code{\link[=connection]{connection()}} object) and "\code{...}" (for)
additional arguments.}

\item{write}{write function. Arguments should be "\code{data}" (a data.frame),
\code{file} (must be able to take a \code{\link[=connection]{connection()}} object), and "\code{omit_header}"
logical, include header (initial write) or not (for appending subsequent
chunks)}

\item{extension}{file extension to use (e.g. "tsv", "csv")}
}
\value{
a \code{streamable_table} object (S3)
}
\description{
streamable table
}
\details{
Note several constraints on this design. The write method must be able
to take a generic R \code{connection} object (which will allow it to handle
the compression methods used, if any), and the read method must be able
to take a \code{textConnection} object.  \code{readr} functions handle these cases
out of the box, so the above method is easy to write.  Also note that
the write method must be able to \code{omit_header}. See the built-in methods
for more examples.
}
\examples{

streamable_readr_tsv <- function() {
  streamable_table(
    function(file, ...) readr::read_tsv(file, ...),
    function(x, path, omit_header) {
      readr::write_tsv(x = x, path = path, omit_header = omit_header)
    },
    "tsv"
  )
}
}
