% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{options.validate}
\alias{options.validate}
\title{Validate a user options file against an options template.}
\usage{
options.validate(
  options_file_name = NULL,
  options_dir = NULL,
  should_flag_redundant = FALSE,
  template_path = NULL,
  failure_action = "abort_verbose",
  verbose = TRUE
)
}
\arguments{
\item{options_file_name}{\emph{[character]} Name of the user options file to validate, including the suffix.}

\item{options_dir}{\emph{[character, optional]} Full path to the folder that contains user options files. If not provided, the default folder is chosen. Defaults to \code{NULL}.}

\item{should_flag_redundant}{\emph{[logical, optional]} If TRUE, warn the user about any extraneous options (i.e., options not defined in the options template, such as custom options that the user might have added). Defaults to FALSE.}

\item{template_path}{\emph{[character, optional]} Full path to the options template file. Defaults to \code{NULL}.}

\item{failure_action}{\emph{[character]} Action to take if validation fails. Can be one of: 'abort_verbose', 'abort_quiet', 'return_errors_verbose', 'return_errors_quiet'. Defaults to 'abort_verbose'.}

\item{verbose}{\emph{[logical, optional]} If TRUE, print additional information about the validation process. Defaults to TRUE.
\code{list} Invisibly returns a list of error messages (empty if no errors).}
}
\value{
\emph{[list]} The validation errors
}
\description{
This function reads a YAML template and an options file, flattens both structures,
and then checks that:
\itemize{
\item Every option defined in the template is present in the options file.
\item The value for each option is of the correct type.
\item (Optionally) It warns about extra options in the file that are not defined in the template.
}
}
\details{
For each problem found (missing option or type mismatch), an error message is printed.
}
