% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_saturation.R
\name{set_saturation}
\alias{set_saturation}
\title{Change the saturation of a hexadecimal color value}
\usage{
set_saturation(color = NULL, percentage = NULL)
}
\arguments{
\item{color}{Character value of length 1 - The color that will have its saturation set. A standard 6 digit hexadecimal webcolor like "#000000" or a valid \code{R} color from \code{colors()} is accepted.}

\item{percentage}{A numeric value of length 1. The percentage of which the saturation should be set. Values from 0 - 1 are accepted.}
}
\value{
A character string (hexadecimal color)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
\dontshow{\}) # examplesIf}

# Load in ggplot2 so we can see the colors
library(ggplot2)

# Create color values
original_color <- "#7340bf" #(original saturation == .5)
desaturated_color <- set_saturation(original_color, .2) #(saturation == \%20)
saturated_color <- set_saturation(original_color, .9) #(saturation == \%90)

# Make a data frame with the color values
df_colors <-
  data.frame(
    x = 0:2,
    y = 1,
    color = c(desaturated_color, original_color, saturated_color)
  )

# Add a label for clarity
df_colors$label <- paste(c("Desaturated", "Original", "Saturated"), ":", df_colors$color)

# Plot to see the saturation changes
df_colors |>
  ggplot(aes(x,y)) +
  geom_label(aes(x = 0:2), y = 2, label = df_colors$label) +
  geom_point(color = df_colors$color, shape = 15, size = 50) +
  coord_cartesian(xlim = c(-1,3), ylim = c(0,3)) +
  theme_void()


}
