% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashCI.R
\name{ashci}
\alias{ashci}
\title{Credible Interval Computation for the ash object}
\usage{
ashci(
  a,
  level = 0.95,
  betaindex,
  lfsr_threshold = 1,
  tol = 0.001,
  trace = FALSE
)
}
\arguments{
\item{a}{the fitted ash object}

\item{level}{the level for the credible interval, (default=0.95)}

\item{betaindex}{a vector consisting of locations of betahat where
you would like to compute the credible interval}

\item{lfsr_threshold}{a scalar, if specified then computes CIs only for observations
more significant than that threshold.}

\item{tol}{passed to uniroot; indicates desired accuracy.}

\item{trace}{a logical variable denoting whether some of the
intermediate results of iterations should be displayed to the
user. Default is FALSE.}
}
\value{
A matrix, with 2 columns, ith row giving CI for ith observation
}
\description{
Given the ash object returned by the main function ash,
    this function computes a posterior credible interval (CI) for each observation. The ash object
    must include a data component to use this function (which it does by default).
}
\details{
Uses uniroot to find credible interval, one at a time for each observation. 
The computation cost is linear in number of observations.
}
\examples{
beta = c(rep(0,20),rnorm(20))
sebetahat = abs(rnorm(40,0,1))
betahat = rnorm(40,beta,sebetahat)
beta.ash = ash(betahat, sebetahat)

CImatrix=ashci(beta.ash,level=0.95)

CImatrix1=ashci(beta.ash,level=0.95,betaindex=c(1,2,5))
CImatrix2=ashci(beta.ash,level=0.95,lfsr_threshold=0.1)
}
