% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_files.R
\name{assert_directory_does_not_exist}
\alias{assert_directory_does_not_exist}
\title{Assert a directory does not exist}
\usage{
assert_directory_does_not_exist(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{Path to a file (string)}

\item{msg}{A character string containing the error message if file \code{x} already exists}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if directory \code{x} does not already exist, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that a directory does not already exist. Useful for avoiding overwriting.
This function is an exact copy of \code{\link[=assert_file_does_not_exist]{assert_file_does_not_exist()}} and included to make assertion code more readable.
}
\examples{
real_dir <- system.file("tests", package = "assertions")

try({
assert_directory_does_not_exist("foo") # Passes
assert_directory_does_not_exist(real_dir) # Throws error
assert_directory_does_not_exist(c("foo", "bar")) # Throws Error (single file only)
})

}
\concept{assert_file}
