% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ata.R
\name{plot.ata}
\alias{plot.ata}
\alias{plot}
\title{Generic Plot Function for Class \code{ata}}
\usage{
\\method{plot}{ata}(x,
      conditem=NA,
      useconst=TRUE,
      itemorder=NA,
      itemlab=NA,
      useitemlab=FALSE,
      together=FALSE,
      ...)
}
\arguments{
\item{x}{An output object of class ata generated by either \code{wdm()} or \code{atalp()} from the \code{ata} package.}

\item{conditem}{Provides a conditional or secondary item classification (i.e. content label). If provided, it must be given in the order of \code{final_ids} in the ata output object.}

\item{useconst}{Indicator whether all constraints from the test assembly process should be visualized or whether only a selection is desired. If a selection is desired, the name of the constraint as given by the \code{constobj} should be provided. Default is \code{TRUE}.}

\item{itemorder}{Identifies the item order with which to visualize constraints. If \code{NA} the observed order in the ata object will be used. If provided, the new order for the order of \code{final_ids} in the ata output object must be given.}

\item{itemlab}{Identifies item labels. Default is \code{NA}. If \code{NA}, then the item ids in the \code{final_ids} vector of the ata output object will be used. If provided, ids must be given in the order of \code{final_ids} in the ata output object.}

\item{useitemlab}{Identifies if items should be labeled. Default is \code{FALSE}. If \code{FALSE} then the item order in the \code{final_ids} vector of the ata output object will be used as labels. If \code{TRUE}, but itemlab is not provided, then the ids from the \code{final_ids} vector will be used.}

\item{together}{Should progress plots be stacked together in one plot? Default is \code{FALSE}. Not advisable for situations with more than 5 constraints.}

\item{...}{Arguments to be passed to methods.}
}
\value{
The function returns plots of the test form constraints and a cumulative additive constraint list for each constraint if assigned to an object.
\item{plots}{For each constraint in the test form two visualizations are considered: 1) A cumulative additive progressive plot showing the change in the constraint total value per selected item, and 2) a plot of the constraint item specific value for each selected item.}
\item{cumulative}{If \code{plot.ata} is assigned to an object, the object will inherit a list of length equal to the number of constraints each element containing the cumulative constraint value after each selected item.}
}
\description{
Default plotting function for output objects of class ata. The function detects the object's method and renders the appropriate visualizations.
}
\author{
Michael Chajewski (mchajewski@hotmail.com)
}
\keyword{"form}
\keyword{"test}
\keyword{ata}
\keyword{constraints}
\keyword{constraints"}
\keyword{form"}
\keyword{test_form}
\keyword{visualization}
