% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_to_LaTeX.R
\name{translate_to_LaTeX}
\alias{translate_to_LaTeX}
\alias{translate_to_LaTeX.data.frame}
\alias{translate_to_LaTeX.list}
\alias{translate_to_LaTeX.character}
\alias{translate_to_LaTeX.numeric}
\alias{translate_to_LaTeX.factor}
\alias{translate_to_LaTeX.logical}
\title{A wrapper for latexTranslate}
\usage{
translate_to_LaTeX(x, ...)

\method{translate_to_LaTeX}{data.frame}(x, ...)

\method{translate_to_LaTeX}{list}(x, ...)

\method{translate_to_LaTeX}{character}(
  x,
  inn = NULL,
  out = NULL,
  pb = FALSE,
  greek = FALSE,
  na = "",
  ...
)

\method{translate_to_LaTeX}{numeric}(x, ...)

\method{translate_to_LaTeX}{factor}(x, ...)

\method{translate_to_LaTeX}{logical}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{inn, out, pb, greek, na, ...}{As in \code{\link[Hmisc]{latex}}.}
}
\value{
Same length as \code{x}, now translated to latex.
}
\description{
Translate_to_LaTeX calls \code{\link[Hmisc:latex]{latexTranslate}}.
}
\details{
Result is suitable for print with \code{\link[Hmisc]{latex}}.

Translate_to_LaTeX uses S3 object system. See seection methods.
}
\section{Methods (by class)}{
\itemize{
\item \code{translate_to_LaTeX(data.frame)}: Applies \code{\link[Hmisc:latex]{latexTranslate}} to
\code{rownames(x)}, \code{colnames(x)} and all columns of \code{x}.

\item \code{translate_to_LaTeX(list)}: Translates all elements of \code{x}.

\item \code{translate_to_LaTeX(character)}: As \code{\link[Hmisc:latex]{latexTranslate}}.

\item \code{translate_to_LaTeX(numeric)}: Casts to character and then translates.

\item \code{translate_to_LaTeX(factor)}: Translates the levels of the factor.

\item \code{translate_to_LaTeX(logical)}: Casts to character and then translates.

}}
