% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_attrib.R
\name{fit_attrib}
\alias{fit_attrib}
\title{Data fit}
\usage{
fit_attrib(data, response, fixef, ranef, offset = NULL)
}
\arguments{
\item{data}{The observed data to be fitted.}

\item{response}{The response}

\item{fixef}{The fixed effects}

\item{ranef}{The random effects}

\item{offset}{The offsets.}
}
\value{
The model fit of the data with additional attributes offset, response and fit_fix.
Offset and response are the same as in the input and fit_fix is the linear model of the fix effects.

For more details see the help vignette:
\code{vignette("intro", package="attrib")}
}
\description{
Data fit using glmer from lme4 with family poisson to fit the dataset with the given formula.
}
\examples{

response <- "deaths"

fixef <- "pr100_ili_lag_1 + sin(2 * pi * (week - 1) / 52) + cos(2 * pi * (week - 1) / 52)"
ranef <- " (pr100_ili_lag_1| season)"
offset <- "log(pop)"

data <- attrib::data_fake_nation


fit_attrib(data = data, response = response, fixef = fixef, ranef = ranef, offset = offset)
}
