% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Generates simulations of expected mortality by simulating the model coefficients.}
\usage{
sim(fit, data, n_sim)
}
\arguments{
\item{fit}{A model fit created by fit_attrib}

\item{data}{The data with either observed values or reference values.}

\item{n_sim}{Number of simulations}
}
\value{
A dataset with 500 simulations of the expected response for each row in the original dataset.
}
\description{
With the given fit from fit_attrib the function sim, from package arm as described in Gelman, Hill (2012) <doi:10.1017/CBO9780511790942>, is used to generate 500 simulations
of all the coefficients, from there respective posterior distributions.
This is then used to compute the expected response for all simulations and rows in the input dataset.
}
\details{
\code{vignette("intro", package="attrib")}
}
\examples{

response <- "deaths"
fixef <- "pr100_ili_lag_1 + sin(2 * pi * (week - 1) / 52) + cos(2 * pi * (week - 1) / 52)"
ranef <- " (pr100_ili_lag_1| season)"
offset <- "log(pop)"

data <- attrib::data_fake_nation

fit <- fit_attrib(data = data, response = response, fixef = fixef, ranef = ranef, offset = offset)

n_sim <- 5
sim(fit, data, n_sim)
}
