% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoimport.R
\name{autoimport}
\alias{autoimport}
\title{Automatically compute \verb{@importFrom} tags}
\usage{
autoimport(
  root = ".",
  ...,
  location = c("function", "package"),
  files = get_R_dir(root),
  namespace_file = "NAMESPACE",
  description_file = "DESCRIPTION",
  use_cache = TRUE,
  ignore_package = TRUE,
  verbose = 2
)
}
\arguments{
\item{root}{Path to the root of the package.}

\item{...}{unused}

\item{location}{Whether to add \verb{@importFrom} dispatched above each function, or centralized at the package level.}

\item{files}{Files to read. Default to the \verb{R/} folder.}

\item{namespace_file}{Path to the NAMESPACE file}

\item{description_file}{Path to the DESCRIPTION file}

\item{use_cache}{Whether to use the cache system. Can only be "read" or "write".}

\item{ignore_package}{Whether to ignore files ending with \code{-package.R}}

\item{verbose}{The higher, the more output printed. May slow the process a bit.}
}
\value{
Mostly used for side effects. Invisibly returns a dataframe summarizing the function imports, with input arguments as attributes.
}
\description{
Automatically read all \code{R} files and compute appropriate \verb{@importFrom} tags in the roxygen2 headers.
The tags can be added to the source files using the \code{\link[=import_review]{import_review()}} shiny app afterward.
}
\section{Limitations}{

Autoimport is based on \code{\link[utils:sourceutils]{utils::getSrcref()}} and share the same limits.
Therefore, some function syntaxes are not recognized and \code{autoimport} will try to remove their \verb{@importFrom} from individual functions:
\itemize{
\item Operators (\verb{@importFrom dplyr \%>\%}, \verb{@importFrom rlang :=}, ...)
\item Functions called by name (e.g. \verb{sapply(x, my_fun))}
\item Functions used inside strings (e.g. \code{glue("my_fun={my_fun(x)}")})
}

To keep them imported, you should either use a prefix (\code{pkg::my_fun}) or import them in your package-level documentation, as this file is ignored by default (with \code{ignore_package=TRUE}).
}

