% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_active.R
\name{log_active}
\alias{log_active}
\title{Check the log thread.}
\usage{
log_active()
}
\value{
\code{TRUE} if a background thread is actively writing to the log,
\code{FALSE} otherwise. The result is based on a static C variable,
so the information is second-hand.
}
\description{
Check if the log is running.
}
\examples{
  path <- tempfile()
  log_active()
  log_start(seconds = 0.5, path = path)
  log_active()
  Sys.sleep(2)
  log_stop()
  Sys.sleep(2)
  log_active()
  unlink(path)
}
