% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_stop.R
\name{log_stop}
\alias{log_stop}
\title{Stop the log thread.}
\usage{
log_stop()
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Stop the background thread that periodically writes
system usage metrics of the current R process to a log file.
}
\details{
The background thread is detached, so is there no way to
directly terminate it (other than terminating the main thread,
i.e. restarting R). \code{\link[=log_stop]{log_stop()}} merely signals to the thread
using a static C variable protected by a mutex. It may take
time for the thread to notice, depending on the value of \code{seconds}
you supplied to \code{\link[=log_start]{log_start()}}. For this reason, you may see one or two
lines in the log even after you call \code{\link[=log_stop]{log_stop()}}.
}
\examples{
  path <- tempfile()
  log_start(seconds = 0.5, path = path)
  Sys.sleep(2)
  log_stop()
  log_read(path)
  unlink(path)
}
