% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$rotate_resid}
\alias{AUTO_VI$rotate_resid}
\title{Get rotated residuals from a fitted linear model}
\arguments{
\item{fitted_model}{\code{lm}. A linear model object.}
}
\value{
A tibble with two columns \code{.fitted} and \code{.resid}.
}
\description{
This function gets rotated residuals from a fitted linear
model. The rotated residuals are generated by first regressing random
noises on the original regressors, then multiply the obtained residuals by
original RSS divided by the current RSS. The results are the rotated
residuals.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$rotate_resid(fitted_model = self$fitted_mod)
}\if{html}{\out{</div>}}
}
}
\examples{

my_vi <- auto_vi(fitted_model = lm(speed ~ dist, data = cars))
rotated_resid <- my_vi$rotate_resid()
my_vi$plot_resid(rotated_resid)
}
