% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av.R
\name{optimal_g}
\alias{optimal_g}
\title{Computes the value of g such that width of the \eqn{1-\alpha} confidence interval
at sample size n is minimized}
\usage{
optimal_g(n, number_of_coefficients, alpha)
}
\arguments{
\item{n}{A positive sample size integer.}

\item{number_of_coefficients}{A positive integer of coefficients in the full model}

\item{alpha}{A positive numeric scalar in (0,1) for nominal Type I error.}
}
\value{
A positive numeric scalar representing the optimal \eqn{g} that minimizes the CI width.
}
\description{
Computes the value of g such that width of the \eqn{1-\alpha} confidence interval
at sample size n is minimized
}
\examples{
n <- 10000
alpha <- 0.05
g_star <- optimal_g(n, 5, alpha)
cat("The optimal g is:", g_star, "\n")

}
