% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{aweSOMscreeplot}
\alias{aweSOMscreeplot}
\title{Screeplot of SOM superclasses}
\usage{
aweSOMscreeplot(
  som,
  nclass = 2,
  method = c("hierarchical", "pam"),
  hmethod = c("complete", "ward.D2", "ward.D", "single", "average", "mcquitty", "median",
    "centroid")
)
}
\arguments{
\item{som}{\code{kohonen} object, a SOM created by the \code{kohonen::som}
function.}

\item{nclass}{number of superclasses to be visualized in the screeplot.
Default is 2.}

\item{method}{Method used for clustering. Hierarchical clustering
("hierarchical") and Partitioning around medoids ("pam") can be used.
Default is hierarchical clustering.}

\item{hmethod}{For hierarchicical clustering, the clustering method, by
default "complete". See the \code{stats::hclust} documentation for more
details.}
}
\value{
No return value, called for side effects.
}
\description{
The screeplot, helps deciding the optimal number of superclasses. Available
for both PAM and hierarchical clustering.
}
\examples{
## Build training data
dat <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
### Scale training data
dat <- scale(dat)
## Train SOM
### Initialization (PCA grid)
init <- somInit(dat, 4, 4)
ok.som <- kohonen::som(dat, grid = kohonen::somgrid(4, 4, 'hexagonal'),
                       rlen = 100, alpha = c(0.05, 0.01),
                       radius = c(2.65,-2.65),
                       init = init, dist.fcts = 'sumofsquares')
## Group cells into superclasses (PAM clustering)
superclust <- cluster::pam(ok.som$codes[[1]], 2)
superclasses <- superclust$clustering
aweSOMscreeplot(ok.som, method = 'hierarchical',
                hmethod = 'complete', nclass = 2)
}
