% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_fleets}
\alias{ec2_delete_fleets}
\title{Delete Fleets}
\usage{
ec2_delete_fleets(
  FleetId,
  TerminateInstances,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{FleetId}{List. The IDs of the EC2 Fleets.}

\item{TerminateInstances}{Logical.   Indicates whether to terminate the instances when the EC2 Fleet is deleted.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Delete Fleets
}
\section{FleetId}{

The IDs of the EC2
Fleets.
}

\section{TerminateInstances}{


Indicates whether to terminate the instances when the EC2 Fleet is
deleted. The default is to terminate the instances.

To let the instances continue to run after the EC2 Fleet is deleted,
specify \code{NoTerminateInstances}. Supported only for fleets of type
\code{maintain} and \code{request}.

For \code{instant} fleets, you cannot specify \code{NoTerminateInstances}. A
deleted \code{instant} fleet with running instances is not supported.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

