% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_terminate_client_vpn_connections}
\alias{ec2_terminate_client_vpn_connections}
\title{Terminate Client Vpn Connections}
\usage{
ec2_terminate_client_vpn_connections(
  ClientVpnEndpointId,
  ConnectionId = NULL,
  Username = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ClientVpnEndpointId}{Character. The ID of the Client VPN endpoint to which the client is connected.}

\item{ConnectionId}{Character. The ID of the client connection to be terminated.[optional]}

\item{Username}{Character. The name of the user who initiated the connection.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Terminates active Client VPN endpoint connections.
This action can be used to terminate a specific client connection, or up
to five connections established by a specific user.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN endpoint to which the
client is connected.
}

\section{ConnectionId}{

The ID of the client connection
to be terminated.
}

\section{Username}{

The name of the user who initiated
the connection. Use this option to terminate all active connections for
the specified user. This option can only be used if the user has
established up to five connections.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

