% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_delete_service}
\alias{ecs_delete_service}
\title{Delete Service}
\usage{
ecs_delete_service(
  cluster = NULL,
  service = NULL,
  force = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete.}

\item{service}{Character. The name of the service to delete.}

\item{force}{Logical. If \code{true}, allows you to delete a service even if it has not been scaled down to zero tasks.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Delete Service
}
\section{cluster}{

The short name or
full Amazon Resource Name (ARN) of the cluster that hosts the service to
delete. If you do not specify a cluster, the default cluster is
assumed.
}

\section{service}{

The name of the service to
delete.
}

\section{force}{

If \code{true}, allows you to delete a service
even if it has not been scaled down to zero tasks. It is only necessary
to use this if the service is using the \code{REPLICA} scheduling
strategy.
}

