% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_list_task_definition_families}
\alias{ecs_list_task_definition_families}
\title{List Task Definition Families}
\usage{
ecs_list_task_definition_families(
  maxResults = NULL,
  nextToken = NULL,
  familyPrefix = NULL,
  status = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{maxResults}{Character. Pagination limit[optional]}

\item{nextToken}{Characters. The token for the next page of results[optional]}

\item{familyPrefix}{Character. The \code{familyPrefix} is a string that is used to filter the results of \code{ListTaskDefinitionFamilies}.}

\item{status}{Character. The task definition family status with which to filter the \code{ListTaskDefinitionFamilies} results.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
List Task Definition Families
}
\section{maxResults}{

Pagination
limit
}

\section{familyPrefix}{

The
\code{familyPrefix} is a string that is used to filter the results of
\code{ListTaskDefinitionFamilies}. If you specify a \code{familyPrefix}, only task
definition family names that begin with the \code{familyPrefix} string are
returned.
}

\section{status}{

The task definition family status with
which to filter the \code{ListTaskDefinitionFamilies} results. By default,
both \code{ACTIVE} and \code{INACTIVE} task definition families are listed. If
this parameter is set to \code{ACTIVE}, only task definition families that
have an \code{ACTIVE} task definition revision are returned. If this
parameter is set to \code{INACTIVE}, only task definition families that do
not have any \code{ACTIVE} task definition revisions are returned. If you
paginate the resulting output, be sure to keep the \code{status} value
constant in each subsequent request.
}

