% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data_key.R
\name{generate_data_key}
\alias{generate_data_key}
\title{Generate data keys}
\usage{
generate_data_key(key, spec = c("AES_256", "AES_128"), plaintext = TRUE, ...)
}
\arguments{
\item{key}{A character string specifying a key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with \dQuote{alias/}.}

\item{spec}{A character string specifying the length of the data encryption key, either \dQuote{AES_256} or \dQuote{AES_128}.}

\item{plaintext}{A logical indicating whether to return the data key in plain text, as well as in encrypted form.}

\item{\dots}{Additional arguments passed to \code{\link{kmsHTTP}}.}
}
\value{
\code{encrypt} returns a base64-encoded binary object as a character string.
}
\description{
Generate data keys for local encryption
}
\details{
This function generates and returns a \dQuote{data key} for use in local encrption. The suggested workflow from AWS is to encrypt, do the following:
 
 \enumerate{
   \item Use this operation (\code{generate_data_key}) to get a data encryption key.
   \item Use the plaintext data encryption key (returned in the Plaintext field of the response) to encrypt data locally, then erase the plaintext data key from memory.
   \item Store the encrypted data key (returned in the CiphertextBlob field of the response) alongside the locally encrypted data.
 }

Then to decrypt locally:
  
  \enumerate{
    \item Use \code{\link{decrypt}} to decrypt the encrypted data key into a plaintext copy of the data key.
    \item Use the plaintext data key to decrypt data locally, then erase the plaintext data key from memory.
  }
}
\examples{
\dontrun{
  # create a (CMK) key
  k <- create_kms_key()
  
  # generate a data key for local encryption
  datakey <- generate_data_key(key = k)
  
  ## encrypt something locally using datakey$Plaintext
  ## then delete the plaintext key
  datakey$Plaintext <- NULL
  
  # decrypt the encrypted data key
  datakey$Plaintext <- decrypt(datakey$CiphertextBlob, k, encode = FALSE)
  ## then use this to decrypt locally
  
  # cleanup
  delete_kms_key(k)
}
}
\references{
\url{https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey.html}
}
\seealso{
\code{\link{create_kms_key}}, \code{\link{generate_blob}}
}
