% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbSi.R
\name{pbSi}
\alias{pbSi}
\title{Calculate \%bSi}
\usage{
pbSi(
  C0,
  Vol_Na2CO3,
  Molar_mass_silicon,
  sample_dry_weight,
  output_dir = tempdir()
)
}
\arguments{
\item{C0}{Concentration of silica from biogenic sources (mole/L).}

\item{Vol_Na2CO3}{Vol. Na2CO3 (L) for samples digested in 40.0 ml Na2CO3.}

\item{Molar_mass_silicon}{Molar mass of silicon (g/mole).}

\item{sample_dry_weight}{Dry sample weight, the measured weight of each sample in grams (0.05 +/- 0.005g).}

\item{output_dir}{The directory where the output CSV file should be saved. Defaults to the temporary directory (tempdir()).}
}
\value{
\%bSi value calculated using the formula.
}
\description{
Calculate the bSi percent based on the provided formula.
}
\examples{


C0 <- 0.01# Concentration of silica from biogenic sources mol/L
Vol_Na2CO3 <- 0.04  # Vol. Na2CO3 (L)
Molar_mass_silicon <- 28.09  # Molar mass of silicon (g/mol)
sample_dry_weight <- 0.05  # Sample dry weight (g)
result <- pbSi(C0, Vol_Na2CO3, Molar_mass_silicon, sample_dry_weight, output_dir = tempdir())
print(result)


}
