% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_dist.R
\name{set_prior_val}
\alias{set_prior_val}
\title{Add prior values to Stan input for baggr}
\usage{
set_prior_val(target, name, prior, p = 1, to_array = FALSE)
}
\arguments{
\item{target}{list object (Stan input) to which prior will be added}

\item{name}{prior name, like \code{hypermean}, \code{hypersd}, \code{hypercor}}

\item{prior}{one of prior distributions allowed by baggr like \link{normal}}

\item{p}{number of repeats of the prior, i.e. when P i.i.d. priors are set for
P dimensional parameter as in "mu & tau" type of model}

\item{to_array}{for some models where \code{p} may be larger than 1, Stan will expect
an array instead of a numeric (even when p == 1), so for compatibiliy
we return \code{fam} as an array type}
}
\description{
Add prior values to Stan input for baggr
}
