% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasons_raw.R
\docType{data}
\name{seasons_raw}
\alias{seasons_raw}
\title{Data about each season aired in the US (raw)}
\format{
A data frame with 8 rows representing individual series and 11
variables:
\describe{
\item{series}{an integer denoting UK series (\code{1}-\code{8})}
\item{episode}{an integer denoting total number of episodes within series}
\item{us_season}{an integer denoting US season (\code{1}-\code{5})}
\item{us_airdate}{a date denoting original airdate of episode in the US,
according to
\href{https://www.pbs.org/food/shows/great-british-baking-show/}{pbs.org}}
}
}
\source{
US airdates manually recorded from
\url{https://www.pbs.org/food/shows/great-british-baking-show/}
}
\usage{
seasons_raw
}
\description{
This data has one row per season aired in the US as 'The Great British
Baking Show'.
}
\examples{
if (require('tibble')) {
  seasons_raw
 }
head(seasons_raw)
}
\keyword{datasets}
