#' Extend border of bounded box by +/- e
#'
#' @param parameters A vector of parameters (real numbers) that is generated by estimating the short, intermediate and auxiliary regressions.
#' @param deltalow The lower limit of delta.
#' @param deltahigh The upper limit of delta.
#' @param Rlow The lower limit of Rmax.
#' @param Rhigh The upper limit of Rmax.
#' @param e The step size.
#'
#' @importFrom purrr "set_names"
#' @importFrom dplyr "rowwise"
#' @importFrom stats "quantile"
#' 
#' @return Data frame.
#' @export
#'
#' 
expand_border <- function(parameters,deltalow,deltahigh,Rlow,Rhigh,e){
  # Define the vector of points in the Rmax range
  Rrange <- seq(Rlow,Rhigh,by=e)
  
  # Create new set of points by expanding the boundary by +/- e. Ensure that new delta value != 1.
  rbind(
    expand.grid(ifelse(deltalow-e!=1,deltalow-e,deltalow-e/2),Rrange),
    expand.grid(ifelse(deltahigh+e!=1,deltahigh+e,deltahigh+e/2),Rrange)
  ) %>%
    set_names("delta","Rmax") %>%
    mutate(D = mydisc(parameters,delta,Rmax))
}
