% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osterdelstar.R
\name{osterdelstar}
\alias{osterdelstar}
\title{Computes delta* according to Oster (2019)}
\usage{
osterdelstar(parameters, Rmax)
}
\arguments{
\item{parameters}{A vector of parameters that is generated after estimating the short, intermediate and auxiliary regressions.}

\item{Rmax}{A real number that lies between Rtilde (R-squared for the intermediate regression) and 1.}
}
\value{
A data frame with three columns:

\item{delstar}{The value of delta for the chosen value of Rmax}
\item{discontinuity}{Indicates whether the point of discontinuity is within the interval formed by Rtilde and 1}
\item{slope}{Slope of the function, delta=f(Rmax)}
}
\description{
Computes delta* according to Oster (2019)
}
\examples{
## Load data set
data("NLSY_IQ")
 
## Set age and race as factor variables
NLSY_IQ$age <- factor(NLSY_IQ$age)
NLSY_IQ$race <- factor(NLSY_IQ$race)
   
## Collect parameters from the short, intermediate and auxiliary regressions
parameters <- collect_par(
data = NLSY_IQ, outcome = "iq_std", 
treatment = "BF_months", 
control = c("age","sex","income","motherAge","motherEDU","mom_married","race"),
other_regressors = c("sex","age"))

## Oster's method: delta* (for Rmax=0.61)
osterdelstar(parameters = parameters, Rmax=0.61)

}
