% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{set_prior}
\alias{set_prior}
\title{Set a prior distribution to a model parameter.}
\usage{
set_prior(model, par = "ar", dist = normal(), lag = 0)
}
\arguments{
\item{model}{a time series model class specified in \pkg{varstan}.}

\item{par}{a string value with the  desired parameter which a prior is defined.
Possible arguments are: \code{"mu0"}, \code{"sigma0"}, \code{"ar"}, \code{"ma"}, \code{"arch"}, \code{"garch"},
\code{"mgarch"}, \code{"dfv"}, \code{"df"}, or \code{"breg"}.}

\item{dist}{the distribution of the prior parameter. The only accepted argument
is a \code{prior_dist} object.}

\item{lag}{an optional integer value, indicates the desired lag of the parameter
to impose a prior. If \code{lag = 0}, then the prior distribution will be applied
for all lags.}
}
\value{
a time series model class specified in \pkg{bayesforecast} with the
changed prior.
}
\description{
Setting a prior distribution to an specify model parameter.
}
\details{
\code{bayesforecast} provides its own functions to manipulate the parameter prior,
this functions return a \code{prior_dist} class, the \code{dist} argument
only accepts this objects.

\code{lag} parameter is an optional value to change the prior distribution of
one parameter in particular, this argument is only valid for: \code{"ar"}, \code{"ma"},
\code{"arch"}, \code{"garch"}, \code{"mgarch"}, or \code{"breg"} arguments. The \code{lag} option has
to be a integer lower than the total amount of lagged parameters of the model.
For example,
to  ONLY change the prior of the second \code{"arch"} parameter in a \code{garch(3,1)}
model, a \code{lag = 2} option must be specified.
}
\examples{
dat = Sarima(birth,order = c(1,1,2))
dat = set_prior(model = dat, par = "ar", dist = normal(0,2))
dat

dat = set_prior(model = dat, par = "mu0", dist = student(mu = 0,sd = 2.5,df = 7))
dat

dat = set_prior(model = dat, par = "ma",dist= beta(shape1 = 2, shape2 = 2), lag = 2)
dat

}
\author{
Asael Alonzo Matamoros
}
