% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boc.R
\name{boc_data}
\alias{boc_data}
\title{Fetch Bank of Canada (BoC) data}
\source{
\url{https://www.bankofcanada.ca/valet/docs}
}
\usage{
boc_data(
  group_name = NULL,
  series_name = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{group_name}{(\code{NULL} | \code{character(1)})\cr
Name of the group. Only one of \code{group_name} or \code{series_name} can be used.}

\item{series_name}{(\code{NULL} | \code{character()})\cr
Name of the series.}

\item{start_date}{(\code{NULL} | \code{Date(1)} | \code{character(1)})\cr
Start date of the data. Default \code{NULL}.}

\item{end_date}{(\code{NULL} | \code{Date(1)} | \code{character(1)})\cr
End date of the data. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the Bank of Canada Valet API.
}
\examples{
\dontrun{
# fetch all data for a single group
dt <- boc_data(group_name = "FX_RATES_DAILY")
head(dt)

# or for multiple series ids
dt <- boc_data(
  series_name = c("FXUSDCAD", "FXEURCAD"),
  start_date = "2023-01-23",
  end_date = "2023-07-19"
)
head(dt)
}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
