% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_Bes.R
\name{simdata_bes}
\alias{simdata_bes}
\title{simdata_bes}
\usage{
simdata_bes(kap, lam, x, v, repetitions = 1, link.mean, link.precision)
}
\arguments{
\item{kap}{coefficients in kappa related to the mean parameter.}

\item{lam}{coefficients in lambda related to the precision parameter.}

\item{x}{matrix containing the covariates for the mean submodel. Each column is a different covariate.}

\item{v}{matrix containing the covariates for the precision submodel. Each column is a different covariate.}

\item{repetitions}{the number of random draws to be made.}

\item{link.mean}{a string containing the link function for the mean.
The possible link functions for the mean are "logit","probit", "cauchit", "cloglog".}

\item{link.precision}{a string containing the link function the precision parameter.
The possible link functions for the precision parameter are "identity", "log", "sqrt", "inverse".}
}
\value{
a list of response vectors z (with 0 < z_i < 1).
}
\description{
Function to generate synthetic data from the bessel regression.
Requires the R package "statmod" generate random numbers from the Inverse Gaussian distribution (\emph{Giner and Smyth, 2016}).
}
\examples{
n = 100; x = cbind(rbinom(n, 1, 0.5), runif(n, -1, 1)); v = runif(n, -1, 1);
z = simdata_bes(kap = c(1, -1, 0.5), lam = c(0.5, -0.5), x, v,
repetitions = 1, link.mean = "logit", link.precision = "log")
z = unlist(z)
hist(z, xlim = c(0, 1), prob = TRUE)
}
\references{
DOI:10.32614/RJ-2016-024 (\href{https://journal.r-project.org/archive/2016/RJ-2016-024/index.html}{Giner and Smyth; 2016})
}
\seealso{
\code{\link{dbessel}}, \code{\link{dbbtest}}, \code{\link{simdata_bet}}
}
