% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_filter_out_names.R
\name{bdc_filter_out_names}
\alias{bdc_filter_out_names}
\title{Filter out records according to their taxonomic status}
\usage{
bdc_filter_out_names(
  data,
  col_name = "notes",
  taxonomic_status = "accepted",
  opposite = FALSE
)
}
\arguments{
\item{data}{data.frame. Containing the column "notes" with information on the
taxonomic status of scientific names.}

\item{col_name}{character string. The column name containing notes
about the taxonomic status of a name. Default = "notes".}

\item{taxonomic_status}{character string. Taxonomic status of a name. Default
= "accepted".}

\item{opposite}{logical. Should taxonomic status different from those listed
in 'taxonomic_status' be returned? Default = FALSE}
}
\value{
A data.frame filtered out according to names listed in
'taxonomic_status'.
}
\description{
This function is useful for selecting records according to their taxonomic
status.  By default, only records with accepted scientific names are
returned.
}
\details{
By default, only records with accepted scientific names are kept in
the database. Such records are listed in the column 'taxonomic_status' as
"accepted", "accepted | replaceSynonym",  "accepted | wasMisspelled" or
"accepted | wasMisspelled | replaceSynonym". It is also possible to
customize the list of taxonomic notes to be kept in the argument
'taxonomic_status'. See 'notes' in the data.frame resulted from the function
\code{\link{bdc_create_report}}. If 'opposite' is TRUE, records with notes
different from names listed in 'taxonomic_status' are returned.
}
\examples{
df_notes <-
  data.frame(
    notes = c(
      "notFound", "accepted", "accepted | replaceSynonym",
      "accepted | wasMisspelled",
      "accepted | wasMisspelled | replaceSynonym",
      "multipleAccepted",
      "heterotypic synonym"
    )
  )

bdc_filter_out_names(
  data = df_notes,
  taxonomic_status = "accepted",
  col_name = "notes",
  opposite = FALSE
)

}
\seealso{
Other taxonomy: 
\code{\link{bdc_clean_names}()},
\code{\link{bdc_query_names_taxadb}()}
}
\concept{taxonomy}
