% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericPipe.R
\name{GenericPipe}
\alias{GenericPipe}
\title{Abstract super class that handles the management of the Pipes}
\description{
Provides the required methods to successfully handle each
\code{\link{GenericPipe}} class.
}
\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.log}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GenericPipe-new}{\code{GenericPipe$new()}}
\item \href{#method-GenericPipe-pipe}{\code{GenericPipe$pipe()}}
\item \href{#method-GenericPipe-getPropertyName}{\code{GenericPipe$getPropertyName()}}
\item \href{#method-GenericPipe-getAlwaysBeforeDeps}{\code{GenericPipe$getAlwaysBeforeDeps()}}
\item \href{#method-GenericPipe-getNotAfterDeps}{\code{GenericPipe$getNotAfterDeps()}}
\item \href{#method-GenericPipe-setPropertyName}{\code{GenericPipe$setPropertyName()}}
\item \href{#method-GenericPipe-setAlwaysBeforeDeps}{\code{GenericPipe$setAlwaysBeforeDeps()}}
\item \href{#method-GenericPipe-setNotAfterDeps}{\code{GenericPipe$setNotAfterDeps()}}
\item \href{#method-GenericPipe-hash}{\code{GenericPipe$hash()}}
\item \href{#method-GenericPipe-clone}{\code{GenericPipe$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \link{GenericPipe} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$new(propertyName, alwaysBeforeDeps, notAfterDeps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the Pipe.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (Pipes that must be executed before this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies notAfter
(Pipes that cannot be executed after this one).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Abstract method to preprocess the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The preprocessed \code{\link{Instance}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-getPropertyName"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-getPropertyName}{}}}
\subsection{Method \code{getPropertyName()}}{
Gets of name of property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$getPropertyName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-getAlwaysBeforeDeps"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-getAlwaysBeforeDeps}{}}}
\subsection{Method \code{getAlwaysBeforeDeps()}}{
Gets of the dependencies always before.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$getAlwaysBeforeDeps()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of dependencies always before.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-getNotAfterDeps"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-getNotAfterDeps}{}}}
\subsection{Method \code{getNotAfterDeps()}}{
Gets of the dependencies not after.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$getNotAfterDeps()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of dependencies not after.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-setPropertyName"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-setPropertyName}{}}}
\subsection{Method \code{setPropertyName()}}{
Changes the value of property's name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$setPropertyName(propertyName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. The new value of the
property's name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-setAlwaysBeforeDeps"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-setAlwaysBeforeDeps}{}}}
\subsection{Method \code{setAlwaysBeforeDeps()}}{
Changes the value of dependencies always before.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$setAlwaysBeforeDeps(alwaysBeforeDeps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The new value of the
dependencies always before.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-setNotAfterDeps"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-setNotAfterDeps}{}}}
\subsection{Method \code{setNotAfterDeps()}}{
Changes the value of dependencies not after.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$setNotAfterDeps(notAfterDeps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{notAfterDeps}}{A \code{\link{list}} value. The new value of the
dependencies not after.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-hash"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-hash}{}}}
\subsection{Method \code{hash()}}{
Generates an identification of pipe based on its fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$hash(algo = "md5")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{algo}}{Algorithm to be applied. Options: "md5", "sha1", "crc32",
"sha256", "sha512", "xxhash32", "xxhash64", "murmur32", "spookyhash}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GenericPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
