% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdpar.log.R
\name{bdpar.log}
\alias{bdpar.log}
\title{Write messages to the log at a given priority level using
the custom bdpar log}
\usage{
bdpar.log(message, level = "INFO", className = NULL, methodName = NULL)
}
\arguments{
\item{message}{A string to be printed to the log with the corresponding
priority level.}

\item{level}{The desired priority level (DEBUG,INFO,WARN,ERROR and FATAL).
In the case of the FATAL level will be call to the stop function. Also, if
the level is WARN, the message will be a warning.}

\item{className}{A string to indicated in which class is called to the log.
If the value is NULL, this field is not shown in the log.}

\item{methodName}{A string to indicated in which method is called to the log.
If the value is NULL, this field is not shown in the log.}
}
\description{
\code{bdpar.log} is responsible for managing the messages to
show on the log.
}
\note{
In the case of multithreading, the log will only be by file.
}
\section{Details}{

The format output is as following:

[currentTime][className][methodName][level] message

The type of message changes according to the level indicated:

- The \strong{DEBUG},\strong{INFO} and \strong{ERROR} levels return a text
using the \code{\link{message}} function.

- The \strong{WARN} level returns a text using the \code{\link{warning}} function.

- The \strong{FATAL} level returns a text using the \code{\link{stop}} function.
}

\examples{
\dontrun{

# First step, configure the behavior of log

bdpar.options$configureLog(console = TRUE, threshold = "DEBUG", file = NULL)

message <- "Message example"

className <- "Class name example"

methodName <- "Method name example"

bdpar.log(message = message, level = "DEBUG", className = NULL, methodName = NULL)

bdpar.log(message = message, level = "INFO", className = className, methodName = methodName)

bdpar.log(message = message, level = "WARN", className = className, methodName = NULL)

bdpar.log(message = message, level = "ERROR", className = NULL, methodName = NULL)

bdpar.log(message = message, level = "FATAL", className = NULL, methodName = methodName)
}

}
\seealso{
\code{\link{bdpar.Options}}
}
