% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beaGet.r
\name{beaGet}
\alias{beaGet}
\title{Pass list of user specifications (including API key) to return data from BEA API.}
\usage{
beaGet(beaSpec, asString = FALSE, asList = FALSE, asTable = TRUE,
  asWide = TRUE, isMeta = FALSE, iTableStyle = TRUE)
}
\arguments{
\item{beaSpec}{A list of user specifications (required). In this example, 'GetData' specifies that we want data values (rather than metadata), 'NIPA' specifies the dataset, 'A' specifies that we want annual data, 'TableID' = '68' gets a specific table, and 'X' gets all years. See BEA API documentation or use metadata methods for complete lists of parameters.}

\item{asString}{Return result body as a string (default: FALSE)}

\item{asList}{Return result body as a list  (default: FALSE)}

\item{asTable}{Return result body as a data.table (default: TRUE)}

\item{asWide}{Return data.table in wide format (default: TRUE)}

\item{isMeta}{Special parameter meant to interact with metadata functions (default: FALSE)}

\item{iTableStyle}{If "asWide = TRUE", setting "iTableStyle = TRUE" will return data.table in same format as shown on BEA website, with dates and attributes as column headers and series as rows; otherwise, results have series codes as column headers (default: TRUE)}
}
\value{
By default, an object of class 'list' of several dimensions. View list structure using 'str(yourList)'.
}
\description{
Pass list of user specifications (including API key) to return data from BEA API.
}
\examples{
userSpecList <- list('UserID' = 'yourAPIKey' ,
								'Method' = 'GetData',
								'datasetname' = 'NIPA',
								'Frequency' = 'A',
								'TableID' = '68',
								'Year' = 'X')	
BDT <- beaGet(userSpecList, asTable = TRUE)
}
