% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_analyte.R
\name{get_col_names_args}
\alias{get_col_names_args}
\title{Get column names from the method arguments}
\usage{
get_col_names_args(.list)
}
\arguments{
\item{.list}{}
}
\value{
a character with the column names. If an element names .column_name
is \emph{not} present in the \code{.list}, an empty vector is returned.
}
\description{
Get column names from the method arguments
}
\examples{
library(beadplexr)

list(.column_name = "XXX") |> beadplexr:::get_col_names_args()
list(A = list(.column_name = "XXX")) |> beadplexr:::get_col_names_args()
list(A = list(.column_name = "Inner"), .column_name = "Outer") |> beadplexr:::get_col_names_args()
list(A = "ccc") |> beadplexr:::get_col_names_args()

}
\keyword{internal}
