% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26_bullPutLadderPnL.R
\name{bullPutLadderPnLatExpiration}
\alias{bullPutLadderPnLatExpiration}
\title{Calculates per share Profit and Loss at expiration for Bull Put Ladder and draws its graph in the Plots tab.}
\usage{
bullPutLadderPnLatExpiration(
  ST,
  X1L,
  X2M,
  X3H,
  PX1L,
  PX2M,
  PX3H,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Profit / Loss [PnL] at Expiration ($)",
  main = "Bull Put Ladder [ PnL ]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{X2M}{Medium Strike Price or eXercise price.}

\item{X3H}{Higher Strike Price or eXercise price.}

\item{PX1L}{Put Premium paid for the bought Put at Lower Strike.}

\item{PX2M}{Put Premium paid for the bought Put at Medium Strike.}

\item{PX3H}{Put Premium received for the sold Put at higher Strike .}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
This is a vertical spread consisting of a short position in (usually) a close to ATM put option with a strike price X3H, a long position in an OTM put option with a strike price X2M, and a long position in another OTM put option with a lower strike price X1L. A bull put ladder typically arises when a bull put spread (a bullish strategy) goes wrong (that is the stock trades lower), so the trader buys another OTM put option (with the lower strike price X1L) to adjust the position to bearish. On initiation, this is a net credit Strategy and results in net cash inflow as premium received on shorting a put (at higher strike) is more than premium paid on buying two puts (buying one put at t somewhat middle priced strike X2M and then one more put at lower strike X1L).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Bull Put Ladder and draw its graph in the Plots tab. EXAMPLE: Shorting HypoQuant December 24 put at $2.40 , buy HypoQuant December 21 put at $1.00, and then again buy HypoQuant December 19 put at $0.40. The graph gets displayed in Plots tab (Kakushadze & Serur, 2018).
}
\examples{
bullPutLadderPnLatExpiration(19,19,21,24,0.40,1.00,2.40)
bullPutLadderPnLatExpiration(200,200,205,209,2,5,7,hl=0.95,hu=1.1)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
