% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-plots.R
\name{approx_mvn_at_time}
\alias{approx_mvn_at_time}
\title{Approximate Multivariate Normal Distribution as Beta at a Specific Time}
\usage{
approx_mvn_at_time(x, time)
}
\arguments{
\item{x}{A vector of distributional objects that must be either multivariate normal
distributions or mixtures of multivariate normal distributions. For Weibull models,
these represent distributions of the log(shape) and log(scale) parameters.}

\item{time}{A numeric value specifying survival time at which to calculate the
survival probability.}
}
\value{
A vector of beta distributional (or mixture of beta distributional)
objects approximating the survival probabilities at the specified time
point. If the input is a mixture distribution, the output will be a mixture
of beta distributions with the same weights.
}
\description{
Converts a multivariate normal distribution for Weibull parameters (or a mixture
of these distributions) into an approximate beta distribution for the survival
probability at a specific time point. This is particularly useful for visualizing
survival probabilities in sweet spot plots
}
\details{
The function performs the following steps:
\itemize{
\item For each multivariate normal distribution, it generates 10,000 samples of the
Weibull parameters
\item Calculates the corresponding survival probabilities at the specified time
using the Weibull survival function
\item Fits a beta distribution to match the mean and variance of these survival
probabilities
\item For mixture distributions, it performs this approximation for each component
and creates a new mixture with the same weights
}

The conversion uses the relationship between Weibull parameters and survival
probability: S(t) = exp(-(t*exp(log_scale))^exp(log_shape)).
}
\examples{

library(distributional)

# Create a multivariate normal distribution for Weibull parameters
# (log(shape), log(scale))
mvn_dist <- dist_multivariate_normal(
  mu = list(c(0, -1)),  # log(shape) = 0, log(scale) = -1
  sigma = list(matrix(c(0.1, 0, 0, 0.1), nrow = 2))
)

# Approximate as beta distribution for survival at time t=12
beta_approx <- approx_mvn_at_time(mvn_dist, time = 12)


}
\seealso{
\code{\link[=sweet_spot_plot]{sweet_spot_plot()}}
}
