% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_prior_and_mcmc_params.R
\name{psd_tvarma12}
\alias{psd_tvarma12}
\title{time-varying spectral density function of the tvARMA(1,2) processes for illustrations}
\usage{
psd_tvarma12(
  rescaled_time,
  freq,
  dgp = NULL,
  a1 = function(u) {
     rep(0, length(u))
 },
  b1 = function(u) {
     rep(0, length(u))
 },
  b2 = function(u) {
     rep(0, length(u))
 }
)
}
\arguments{
\item{rescaled_time, freq}{numeric vectors forming a rectangular grid on which the tv-PSD is evaluated.}

\item{dgp}{optional: the tv-ARMA models demonstrated in section 4.2 of Tang et al. (2023). 
Should be chosen from "LS1", "LS2" and "LS3". See section Details.}

\item{a1, b1, b2}{If dgp is not supplied, these arguments can be used to specify customized tv-ARMA
process (up to order(1,2)). See Details.
rescaled_time must be in \eqn{[0,1]} and freq must be in \eqn{[0,\pi]}.}
}
\value{
a matrix of dimension length(rescaled_time) by length(freq).
}
\description{
time-varying spectral density function of the tvARMA(1,2) processes for illustrations
}
\details{
See \link{sim_tvarma12} for the precise definition of a tvARMA(1,2) process. The time-varying
spectral density function of this process is defined as

\ifelse{html}{
\out{<math>f(u,&lambda;) = (2&pi;)<sup>-1</sup>(1+b<sub>1</sub><sup>2</sup>(u)+b<sub>2</sub><sup>2</sup>(u)+2b<sub>1</sub>(u)(b<sub>2</sub>(u)+1)cos(&lambda;)+2b<sub>2</sub>(u)cos(2&lambda;))/(1+a<sub>1</sub><sup>2</sup>(u)-2a<sub>1</sub>(u)cos(&lambda;)), (u,&lambda;)&isin;[0,1]&times;[0,&pi;],
</math>}
}{\deqn{f(u,\lambda) = \frac{1}{2\pi}\frac{1 + b_1^2(u) + b_2^2(u) + 2b_1(u)(b_2(u)+1)\cos(\lambda) + 2b_2(u)\cos(2\lambda)}{1+a_1^2(u)-2a_1(u)\cos(\lambda)},\quad (u,\lambda)\in[0,1]\times[0,\pi],}}
where \eqn{u} is called rescaled time and \eqn{\lambda} is called frequency.

For dgp = "LS1", it is a tvMA(2) process (MA order is 2) with

\ifelse{html}{
\out{<math>a<sub>1</sub>(u)=0, b<sub>1</sub>(u)=1.122(1-1.178sin(&pi;/2 u)), 
b<sub>2</sub>(u)=-0.81. </math>}
}{\deqn{a_1(u)=0, b_1(u)= 1.122(1 - 1.178\sin(\pi/2 u)), b_2(u) = -0.81.}}
For dgp = "LS2", it is a tvMA(1) process (MA order is 1) with

\ifelse{html}{
\out{<math>a<sub>1</sub>(u)=0, b<sub>1</sub>(u)=1.1cos(1.5-cos(4&pi; u)), b<sub>2</sub>(u)=0. 
</math>}
}{\deqn{a_1(u)=0, b_1(u)= 1.1\cos\left(1.5 - \cos\left(4\pi u \right) \right), b_2(u) = 0.}}
For dgp = "LS3", it is a tvAR(1) process (MA order is 0) with

\ifelse{html}{
\out{<math>a<sub>1</sub>(u)=1.2u-0.6, b<sub>1</sub>(u)=0, b<sub>2</sub>(u)=0. </math>}
}{\deqn{a_1(u)=1.2u-0.6, b_1(u)= 0, b_2(u) = 0.}}
}
\examples{
\dontrun{
res_time <- seq(0, 1, by = 0.005); freq <- pi*seq(0, 1, by = 0.01)
true_tvPSD <- psd_tvarma12(rescaled_time = res_time, freq = freq, dgp = "LS2")
plot(true_tvPSD)
}
}
\references{
Tang et al. (2023)
\emph{Bayesian nonparametric spectral analysis of locally stationary processes}
ArXiv preprint
<arXiv:2303.11561>
}
