% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_param.R
\name{PlotParam}
\alias{PlotParam}
\title{Plot Param}
\usage{
PlotParam(
  data,
  param,
  ROPE = FALSE,
  monochrome = TRUE,
  plot.colors = c("#495054", "#e3e8ea"),
  font.type = "serif",
  font.size = 4.5,
  rope.line = -0.2,
  rope.tick = -0.1,
  rope.label = -0.35,
  line.size = 0.5,
  dens.zero.col = "black",
  dens.mean.col = "white",
  dens.median.col = "white",
  dens.mode.col = "black",
  dens.rope.col = "black",
  scale = FALSE,
  y.limits = NULL,
  y.breaks = NULL,
  x.limits = NULL,
  x.breaks = NULL,
  plot.title = NULL
)
}
\arguments{
\item{data}{MCMC data to plot}

\item{param}{parameter of interest}

\item{ROPE}{plot ROPE values, Default: FALSE}

\item{monochrome}{logical, indicating whether or not to use monochrome colors, else use \link[bfw]{DistinctColors}, Default: TRUE}

\item{plot.colors}{range of color to use, Default: c("#495054", "#e3e8ea")}

\item{font.type}{font type used for visualizations, Default: 'serif'}

\item{font.size}{font size, Default: 4.5}

\item{rope.line}{size of ROPE lien, Default: -0.2}

\item{rope.tick}{distance to ROPE tick, Default: -0.1}

\item{rope.label}{distance to ROPE label, Default: -0.35}

\item{line.size}{overall line size, Default: 0.5}

\item{dens.zero.col}{colour of line indicating zero, Default: 'black'}

\item{dens.mean.col}{colour of line indicating mean value, Default: 'white'}

\item{dens.median.col}{colour of line indicating median value, Default: 'white'}

\item{dens.mode.col}{colour of line indicating mode value, Default: 'black'}

\item{dens.rope.col}{colour of line indicating ROPE value, Default: 'black'}

\item{scale}{scale x and y axis, Default: FALSE}

\item{y.limits}{vector of y limits, Default: NULL}

\item{y.breaks}{vector of y breaks, Default: NULL}

\item{x.limits}{= vector of x limits, Default: NULL}

\item{x.breaks}{= vector of x breaks, Default: NULL}

\item{plot.title}{= title of plot, Default: NULL}
}
\value{
Density plot of parameter values
}
\description{
Create a density plot with parameter values
}
\seealso{
\code{\link[dplyr]{mutate}},\code{\link[dplyr]{group_by}},\code{\link[dplyr]{join}},\code{\link[dplyr]{select}},\code{\link[dplyr]{slice}},\code{\link[dplyr]{filter}}
 \code{\link[stats]{approxfun}}
 \code{\link[ggplot2]{aes}},\code{\link[ggplot2]{margin}},\code{\link[ggplot2]{geom_density}},\code{\link[ggplot2]{geom_polygon}},\code{\link[ggplot2]{geom_segment}},\code{\link[ggplot2]{geom_label}},\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{ggplot_build}},\code{\link[ggplot2]{scale_continuous}},\code{\link[ggplot2]{theme}},\code{\link[ggplot2]{labs}}
}
