% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class040-bids_project.R
\name{bids_project}
\alias{bids_project}
\alias{BIDSProject}
\title{'BIDS' project class}
\usage{
BIDSProject(
  path,
  raw_data_relpath = ".",
  source_data_relpath = "sourcedata",
  derivative_data_relpath = "derivatives",
  strict = TRUE
)

bids_project(
  path,
  raw_data_relpath = ".",
  source_data_relpath = "sourcedata",
  derivative_data_relpath = "derivatives",
  strict = TRUE
)
}
\arguments{
\item{path}{absolute path to the 'BIDS' project directory;}

\item{raw_data_relpath}{raw data-set path, relative (to the \code{path});}

\item{source_data_relpath}{source data-set path, relative (to the \code{path});}

\item{derivative_data_relpath}{derivative data-set path, relative (to the \code{path});}

\item{strict}{whether \code{path} needs to exist; default is \code{TRUE}}
}
\value{
A 'BIDS' project instance.
}
\description{
'BIDS' project class
}
\examples{


# Run `download_bids_examples()` first
examples <- download_bids_examples(test = TRUE)
if(!isFALSE(examples)) {

  project_path <- file.path(examples, "ieeg_epilepsy_ecog")

  project <- BIDSProject(
    path = project_path,
    raw_data_relpath = ".",
    derivative_data_relpath = "derivatives"
  )

  project

}



}
\author{
Zhengjia Wang
}
