% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_ls_bc.R
\name{bfa_ls_bc}
\alias{bfa_ls_bc}
\title{Bias-Corrected Least Squares Estimators for Bifurcating Autoregressive Models}
\usage{
bfa_ls_bc(
  z,
  p,
  method = "boot1",
  burn = 5,
  B1 = 999,
  B2 = 499,
  boot_est = TRUE,
  boot_data = FALSE
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{method}{method of bias correction. Currently, "boot1", "boot2",
"boot2fast" and "LBC" are supported and they implement single bootstrap,
double bootstrap, fast-double bootstrap, and linear-bias-function
bias-correction, respectively.}

\item{burn}{number of tree generations to discard before starting the
bootstrap sample (replicate)}

\item{B1}{number of bootstrap samples (replicates) used in first round of
bootstrapping}

\item{B2}{number of bootstrap samples (replicates) used in second round of
bootstrapping}

\item{boot_est}{a logical that determines whether the bootstrapped least
squares estimates of the autoregressive coefficients should be returned.
Defaults to TRUE.}

\item{boot_data}{a logical that determines whether the bootstrap samples
should be returned. Defaults to FALSE.}
}
\value{
\item{coef_ls_bc}{bias-corrected least squares estimates of the
autoregressive coefficients}
}
\description{
This function performs bias correction on the least squares estimators of the
autoregressive coefficients in a BAR(p) model using single, double and
fast-double bootstrapping, and the linear-bias-function approach as described
in Elbayoumi and Mostafa (2021).
}
\examples{
z <- bfa_tree_gen(63, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa_ls_bc(z, p=2, method="boot1")
z <- bfa_tree_gen(63, 2, 1, 1, 0.5, 0.5, 0, 10, c(0.5, 0.3))
bfa_ls_bc(z, p=2, method="LBC")
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2021). On the estimation bias
in bifurcating autoregressive models. \emph{Stat}, e342.
}
