% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wof.R
\name{wof}
\alias{wof}
\title{wavelength and frequency}
\usage{
wof(b, c = 340)
}
\arguments{
\item{b}{The known wavelength (m) or frequency (Hz).}

\item{c}{The speed of sound in m/s. As a general rule of thumb, however, c is equal to 1500 m/s in saltwater and 350 m/s in air. Note that the distinction between freshwater and saltwater is important. Sound speed is faster in saltwater than freshwater.}
}
\value{
The unknown wavelength (m) or frequency (Hz) given the identity of input a.
}
\description{
This function finds the length of a sound wave, known as the wavelength (m), or
frequency of a sound (Hz), given the identity of the input. The speed of sound is the default in
air (340 m/s). You may calculate your own value for c relative to the conditions present
in your ecosystem of study via soundSpeed().
}
\examples{
# Given a frequency of 80 Hz in air, what is the wavelength?
wof(80000)
# Given a wavelength of 0.004 m in salt water, what is the frequency?
wof(0.004, c=1500)
}
