% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-parametric.R
\name{compose_parametric_v1.4.2}
\alias{compose_parametric_v1.4.2}
\alias{compose_parametric}
\title{Compose BioCompute Object - Parametric Domain (v1.4.2)}
\usage{
compose_parametric_v1.4.2(df = NULL)

compose_parametric(df = NULL)
}
\arguments{
\item{df}{Data frame. Variables include \code{param} (parameter names),
\code{value} (value of the parameters), and \code{step}
(step number for each parameter).}
}
\value{
A list of class \code{bco.domain}
}
\description{
Non-default parameters customizing the computational flow
which can affect the output of the calculations
(\href{https://github.com/biocompute-objects/BCO_Specification/blob/1.4.2/docs/parametric-domain.md}{domain definition}).
}
\examples{
df_parametric <- data.frame(
  "param" = c(
    "seed", "minimum_match_len",
    "divergence_threshold_percent",
    "minimum_coverage", "freq_cutoff"
  ),
  "value" = c("14", "66", "0.30", "15", "0.10"),
  "step" = c(1, 1, 1, 2, 2)
)

compose_parametric(df_parametric) \%>\% convert_json()
}
