% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_annotation_biomartr.R
\name{check_annotation_biomartr}
\alias{check_annotation_biomartr}
\title{Check whether an annotation file contains outlier lines}
\usage{
check_annotation_biomartr(annotation_file, remove_annotation_outliers = FALSE)
}
\arguments{
\item{annotation_file}{a file path to the annotation file.}

\item{remove_annotation_outliers}{shall outlier lines be removed from the input \code{annotation_file}? 
If yes, then the initial \code{annotation_file} will be overwritten and the removed outlier lines will be stored at \code{\link{tempdir}}
for further exploration.}
}
\description{
Some annotation files include lines with character lengths greater than 65000. 
This causes problems when trying to import such annotation files into R using \code{import}.
To overcome this issue, this function screens for such lines
in a given annotation file and removes these lines so that
\code{import} can handle the file.
}
\examples{
\dontrun{
# download an example annotation file from NCBI RefSeq
Ath_path <- biomartr::getGFF(organism = "Arabidopsis thaliana")
# run annotation file check on the downloaded file
biomartr::check_annotation_biomartr(Ath_path)
# several outlier lines were detected, thus we re-run the
# function using 'remove_annotation_outliers = TRUE'
# to remove the outliers and overwrite the file
biomartr::check_annotation_biomartr(Ath_path, remove_annotation_outliers = TRUE)
}
}
\author{
Hajk-Georg Drost
}
