% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getENSEMBLInfo.R
\name{getENSEMBLInfo}
\alias{getENSEMBLInfo}
\title{Retrieve ENSEMBL info file}
\usage{
getENSEMBLInfo(update = FALSE, divisions = ensembl_divisions())
}
\arguments{
\item{update}{logical, default FALSE. If TRUE, update cached list,
if FALSE use existing cache (if it exists). For cache location see
\code{cachedir()}}

\item{divisions}{character, name of divisions to check, default is all from
\code{ensembl_divisions()}. If NULL, also all is used.}
}
\value{
a tibble table storing info for all available ENSEMBL divisions.
}
\description{
Retrieve species and genome information from
http://rest.ensembl.org/info/species?content-type=application/json/.
}
\examples{
\dontrun{
# look at available divisions
ensembl_divisions()
# retrieve information for all ENSEMBL divisions at once
test <- getENSEMBLInfo()
test
# retrieve information for a particular ENSEMBL division (e.g. EnsemblVertebrates)
test_vertebrates <- get.ensembl.info(update = TRUE, division = "EnsemblVertebrates")
test_vertebrates
}
}
\seealso{
\code{\link{ensembl_divisions}}, \code{\link{get.ensembl.info}}, \code{\link{getKingdomAssemblySummary}}
}
\author{
Hajk-Georg Drost
}
